/**
 * Interfaccia che contiene i metodi che riguardano la visualizzazione 
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public interface IShowMessage {
	
	/**
	 * Metodo che visualizza in un qualche dispositivo un messaggio
	 * @param mess messaggio da visualizzare
	 */
	public void println(Msg mess);
	
	/**
	 * Metodo che permette di visualizzare nel dispositivo 
	 * prescelto una linea vuota
	 *
	 */
	public void println();
	
	/**
	 * Metodo che permette di visualizzare nel dispositivo
	 * prescelto una stringa andando poi a capo
	 * @param s stringa da visualizzare
	 */
	public void println(String s);
	
	/**
	 * Metodo che permette di visualizzare nel dispositivo
	 * prescelto una stringa senza andare poi a capo
	 * @param s stringa da visualizzare
	 */
	public void print(String s);

}
